uniform vec4 backColor;
uniform vec4 frontColor;
uniform float angle;

void main()
{
	vec2 c = gl_TexCoord[0].st - vec2(0.5, 0.5);
	float r = 2.0 * sqrt(c.x*c.x + c.y*c.y);
	float alpha = smoothstep(0.6, 0.7, r) * smoothstep(1.0, 0.9, r);
	float rad = 0.25 + atan(c.y, c.x) / (2.0*3.14159265);
	if (rad<0.0)
		rad += 1.0;
	float pos = smoothstep(rad-0.01, rad+0.01, angle);
	vec4 col = mix(backColor, frontColor, pos);
	col.a = alpha;
	gl_FragColor = col;
}
